/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleStateSet;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.WindowEvent;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import javax.accessibility.AccessibleRole;
import org.openoffice.java.accessibility.AccessibleRoleAdapter;
import org.openoffice.java.accessibility.AccessibleStateAdapter;
import org.openoffice.java.accessibility.Alert;
import org.openoffice.java.accessibility.Application;
import org.openoffice.java.accessibility.Button;
import org.openoffice.java.accessibility.CheckBox;
import org.openoffice.java.accessibility.ComboBox;
import org.openoffice.java.accessibility.Container;
import org.openoffice.java.accessibility.Dialog;
import org.openoffice.java.accessibility.FocusTraversalPolicy;
import org.openoffice.java.accessibility.Frame;
import org.openoffice.java.accessibility.Icon;
import org.openoffice.java.accessibility.Label;
import org.openoffice.java.accessibility.List;
import org.openoffice.java.accessibility.Menu;
import org.openoffice.java.accessibility.MenuContainer;
import org.openoffice.java.accessibility.MenuItem;
import org.openoffice.java.accessibility.NativeFrame;
import org.openoffice.java.accessibility.Paragraph;
import org.openoffice.java.accessibility.RadioButton;
import org.openoffice.java.accessibility.ScrollBar;
import org.openoffice.java.accessibility.Separator;
import org.openoffice.java.accessibility.Table;
import org.openoffice.java.accessibility.TextComponent;
import org.openoffice.java.accessibility.ToggleButton;
import org.openoffice.java.accessibility.ToolTip;
import org.openoffice.java.accessibility.Tree;
import org.openoffice.java.accessibility.Window;

public class AccessibleObjectFactory {
    public static final Type XAccessibleType = new Type(XAccessible.class);
    private static Hashtable objectList = new Hashtable();
    private static java.awt.FocusTraversalPolicy focusTraversalPolicy = new FocusTraversalPolicy();
    private static EventQueue theEventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();

    public static EventQueue getEventQueue() {
        return theEventQueue;
    }

    public static void postFocusGained(Component component) {
        AccessibleObjectFactory.getEventQueue().postEvent(new FocusEvent(component, 1004));
    }

    public static void postWindowGainedFocus(java.awt.Window window) {
        AccessibleObjectFactory.postWindowEvent(window, 207);
    }

    public static void postWindowLostFocus(java.awt.Window window) {
        AccessibleObjectFactory.postWindowEvent(window, 208);
    }

    public static void postWindowActivated(java.awt.Window window) {
        AccessibleObjectFactory.postWindowEvent(window, 205);
    }

    public static void postWindowDeactivated(java.awt.Window window) {
        AccessibleObjectFactory.postWindowEvent(window, 206);
    }

    public static void postWindowOpened(java.awt.Window window) {
        AccessibleObjectFactory.postWindowEvent(window, 200);
    }

    public static void postWindowClosed(java.awt.Window window) {
        AccessibleObjectFactory.postWindowEvent(window, 202);
    }

    public static void invokeAndWait() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void postWindowEvent(java.awt.Window window, int n) {
        theEventQueue.postEvent(new WindowEvent(window, n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Component getAccessibleComponent(XAccessible xAccessible) {
        Component component = null;
        if (xAccessible != null) {
            String string = UnoRuntime.generateOid((Object)xAccessible);
            Hashtable hashtable = objectList;
            synchronized (hashtable) {
                WeakReference weakReference = (WeakReference)objectList.get(string);
                if (weakReference != null) {
                    component = (Component)weakReference.get();
                }
            }
        }
        return component;
    }

    public static void addChild(java.awt.Container container, Object object) {
        try {
            AccessibleObjectFactory.addChild(container, (XAccessible)AnyConverter.toObject((Type)XAccessibleType, (Object)object));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(((Object)((Object)illegalArgumentException)).getClass().getName() + " caught: " + illegalArgumentException.getMessage());
        }
    }

    public static void addChild(java.awt.Container container, XAccessible xAccessible) {
        try {
            XAccessibleStateSet xAccessibleStateSet;
            XAccessibleContext xAccessibleContext;
            if (xAccessible != null && (xAccessibleContext = xAccessible.getAccessibleContext()) != null && (xAccessibleStateSet = xAccessibleContext.getAccessibleStateSet()) != null) {
                Component component = AccessibleObjectFactory.getAccessibleComponent(xAccessible);
                if (component != null) {
                    if (container.equals(component.getParent())) {
                        return;
                    }
                    component.setEnabled(xAccessibleStateSet.contains((short)7));
                    component.setVisible(xAccessibleStateSet.contains((short)30));
                } else {
                    component = AccessibleObjectFactory.createAccessibleComponentImpl(xAccessible, xAccessibleContext, xAccessibleStateSet);
                }
                if (component != null) {
                    if (component instanceof java.awt.Container) {
                        AccessibleObjectFactory.populateContainer((java.awt.Container)component, xAccessibleContext);
                    }
                    container.add(component);
                    if (xAccessibleStateSet.contains((short)11)) {
                        AccessibleObjectFactory.postFocusGained(component);
                    }
                }
            }
        }
        catch (RuntimeException runtimeException) {
            System.err.println(((Object)((Object)runtimeException)).getClass().getName() + " caught: " + runtimeException.getMessage());
            runtimeException.printStackTrace();
        }
    }

    protected static void removeChild(java.awt.Container container, Object object) {
        try {
            XAccessible xAccessible = (XAccessible)AnyConverter.toObject((Type)XAccessibleType, (Object)object);
            Component component = AccessibleObjectFactory.getAccessibleComponent(xAccessible);
            if (component != null) {
                container.remove(component);
                if (component instanceof java.awt.Container) {
                    AccessibleObjectFactory.clearContainer((java.awt.Container)component);
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(((Object)((Object)illegalArgumentException)).getClass().getName() + " caught: " + illegalArgumentException.getMessage());
        }
    }

    protected static void clearContainer(java.awt.Container container) {
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (!(component instanceof java.awt.Container)) continue;
            AccessibleObjectFactory.clearContainer((java.awt.Container)component);
        }
        container.removeAll();
    }

    protected static void populateContainer(java.awt.Container container, XAccessibleContext xAccessibleContext) {
        if (xAccessibleContext != null) {
            try {
                int n = xAccessibleContext.getAccessibleChildCount();
                for (int i = 0; i < n; ++i) {
                    AccessibleObjectFactory.addChild(container, xAccessibleContext.getAccessibleChild(i));
                }
            }
            catch (Exception exception) {
                System.err.println(exception.getClass().getName() + " caught: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    protected static void populateContainer(java.awt.Container container, XAccessibleContext xAccessibleContext, java.awt.Window window) {
        if (xAccessibleContext != null) {
            try {
                int n = xAccessibleContext.getAccessibleChildCount();
                for (int i = 0; i < n; ++i) {
                    XAccessibleContext xAccessibleContext2;
                    Component component;
                    XAccessible xAccessible = xAccessibleContext.getAccessibleChild(i);
                    if (xAccessible == null || (component = AccessibleObjectFactory.createAccessibleComponent(xAccessible, xAccessibleContext2 = xAccessible.getAccessibleContext(), window)) == null) continue;
                    if (component instanceof java.awt.Container) {
                        AccessibleObjectFactory.populateContainer((java.awt.Container)component, xAccessibleContext2, window);
                    }
                    container.add(component);
                }
            }
            catch (Exception exception) {
                System.err.println(exception.getClass().getName() + " caught: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    protected static Component createAccessibleComponent(XAccessible xAccessible) {
        try {
            XAccessibleContext xAccessibleContext = xAccessible.getAccessibleContext();
            if (xAccessibleContext != null) {
                return AccessibleObjectFactory.createAccessibleComponentImpl(xAccessible, xAccessibleContext, xAccessibleContext.getAccessibleStateSet());
            }
        }
        catch (RuntimeException runtimeException) {
            System.err.println(((Object)((Object)runtimeException)).getClass().getName() + " caught: " + runtimeException.getMessage());
            runtimeException.printStackTrace();
        }
        return null;
    }

    protected static Component createAccessibleComponent(XAccessible xAccessible, XAccessibleContext xAccessibleContext, java.awt.Window window) {
        if (xAccessibleContext != null) {
            try {
                XAccessibleStateSet xAccessibleStateSet = xAccessibleContext.getAccessibleStateSet();
                Component component = AccessibleObjectFactory.createAccessibleComponentImpl(xAccessible, xAccessibleContext, xAccessibleStateSet);
                if (component != null) {
                    if (xAccessibleStateSet.contains((short)11) && window instanceof NativeFrame) {
                        ((NativeFrame)((Object)window)).setInitialComponent(component);
                    }
                    return component;
                }
            }
            catch (RuntimeException runtimeException) {
                System.err.println(((Object)((Object)runtimeException)).getClass().getName() + " caught: " + runtimeException.getMessage());
                runtimeException.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Component createAccessibleComponentImpl(XAccessible xAccessible, XAccessibleContext xAccessibleContext, XAccessibleStateSet xAccessibleStateSet) {
        Component component = null;
        short s = xAccessibleContext.getAccessibleRole();
        switch (s) {
            case 3: {
                component = new Container(AccessibleRole.CANVAS, xAccessible, xAccessibleContext);
                break;
            }
            case 4: {
                component = new CheckBox(xAccessible, xAccessibleContext);
                break;
            }
            case 7: {
                component = new ComboBox(xAccessible, xAccessibleContext);
                break;
            }
            case 13: {
                component = new Container(AccessibleRole.CANVAS, xAccessible, xAccessibleContext);
                break;
            }
            case 14: {
                component = new Container(AccessibleRole.PANEL, xAccessible, xAccessibleContext);
                break;
            }
            case 15: {
                component = new Container(AccessibleRole.PANEL, xAccessible, xAccessibleContext);
                break;
            }
            case 17: {
                component = new Container(AccessibleRole.FILLER, xAccessible, xAccessibleContext);
                break;
            }
            case 20: {
                component = new Container(AccessibleRole.PANEL, xAccessible, xAccessibleContext);
                break;
            }
            case 19: {
                component = new Container(AccessibleRole.PANEL, xAccessible, xAccessibleContext);
                break;
            }
            case 23: {
                component = new Container(AccessibleRole.PANEL, xAccessible, xAccessibleContext);
                break;
            }
            case 25: {
                component = new Container(AccessibleRole.PANEL, xAccessible, xAccessibleContext);
                break;
            }
            case 28: {
                component = new Icon(xAccessible, xAccessibleContext);
                break;
            }
            case 30: {
                component = new Label(xAccessible, xAccessibleContext);
                break;
            }
            case 31: {
                component = new Container(AccessibleRole.LAYERED_PANE, xAccessible, xAccessibleContext);
                break;
            }
            case 32: {
                if (xAccessibleStateSet.contains((short)15)) {
                    component = new List(xAccessible, xAccessibleContext);
                    break;
                }
                component = new Container(AccessibleRole.LIST, xAccessible, xAccessibleContext);
                break;
            }
            case 34: {
                component = new Menu(xAccessible, xAccessibleContext);
                break;
            }
            case 35: {
                component = new MenuContainer(AccessibleRole.MENU_BAR, xAccessible, xAccessibleContext);
                break;
            }
            case 36: {
                component = new MenuItem(xAccessible, xAccessibleContext);
                break;
            }
            case 43: {
                component = new MenuContainer(AccessibleRole.POPUP_MENU, xAccessible, xAccessibleContext);
                break;
            }
            case 37: {
                component = new Container(AccessibleRole.OPTION_PANE, xAccessible, xAccessibleContext);
                break;
            }
            case 38: {
                component = new Container(AccessibleRole.PAGE_TAB, xAccessible, xAccessibleContext);
                break;
            }
            case 39: {
                component = new Container(AccessibleRole.PAGE_TAB_LIST, xAccessible, xAccessibleContext);
                break;
            }
            case 26: 
            case 41: {
                component = new Paragraph(xAccessible, xAccessibleContext);
                break;
            }
            case 40: {
                component = new Container(AccessibleRole.PANEL, xAccessible, xAccessibleContext);
                break;
            }
            case 44: {
                component = new Button(xAccessible, xAccessibleContext);
                break;
            }
            case 46: {
                component = new RadioButton(xAccessible, xAccessibleContext);
                break;
            }
            case 49: {
                component = new Container(AccessibleRole.ROOT_PANE, xAccessible, xAccessibleContext);
                break;
            }
            case 50: {
                component = new ScrollBar(xAccessible, xAccessibleContext);
                break;
            }
            case 51: {
                component = new Container(AccessibleRole.SCROLL_PANE, xAccessible, xAccessibleContext);
                break;
            }
            case 53: {
                component = new Separator(xAccessible, xAccessibleContext);
                break;
            }
            case 52: {
                component = new Container(AccessibleRole.CANVAS, xAccessible, xAccessibleContext);
                break;
            }
            case 56: {
                component = new Container(AccessibleRole.SPLIT_PANE, xAccessible, xAccessibleContext);
                break;
            }
            case 57: {
                component = new Container(AccessibleRole.STATUS_BAR, xAccessible, xAccessibleContext);
                break;
            }
            case 2: 
            case 58: {
                if (xAccessibleStateSet.contains((short)15)) {
                    component = new Table(xAccessible, xAccessibleContext, xAccessibleStateSet.contains((short)18));
                    break;
                }
                component = new Container(AccessibleRole.TABLE, xAccessible, xAccessibleContext);
                break;
            }
            case 59: {
                if (xAccessibleContext.getAccessibleChildCount() > 0) {
                    component = new Container(AccessibleRole.PANEL, xAccessible, xAccessibleContext);
                    break;
                }
                component = new Label(xAccessible, xAccessibleContext);
                break;
            }
            case 60: {
                component = new TextComponent(xAccessible, xAccessibleContext);
                break;
            }
            case 61: {
                component = new Container(AccessibleRole.PANEL, xAccessible, xAccessibleContext);
                break;
            }
            case 62: {
                component = new ToggleButton(xAccessible, xAccessibleContext);
                break;
            }
            case 63: {
                component = new Container(AccessibleRole.TOOL_BAR, xAccessible, xAccessibleContext);
                break;
            }
            case 64: {
                component = new ToolTip(xAccessible, xAccessibleContext);
                break;
            }
            case 65: {
                component = new Tree(xAccessible, xAccessibleContext);
                break;
            }
            case 66: {
                component = new Container(AccessibleRole.VIEWPORT, xAccessible, xAccessibleContext);
                break;
            }
            default: {
                System.err.println("Unmapped accessible object " + s);
                System.err.println("usually mapped to " + AccessibleRoleAdapter.getAccessibleRole(s));
                component = new Container(AccessibleRoleAdapter.getAccessibleRole(s), xAccessible, xAccessibleContext);
            }
        }
        if (component != null) {
            Hashtable hashtable = objectList;
            synchronized (hashtable) {
                objectList.put(component.toString(), new WeakReference<Component>(component));
            }
            AccessibleStateAdapter.setComponentState(component, xAccessibleStateSet);
        }
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void disposing(Component component) {
        if (component != null) {
            Hashtable hashtable = objectList;
            synchronized (hashtable) {
                objectList.remove(component.toString());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static java.awt.Window getTopWindow(XAccessible xAccessible) {
        java.awt.Window window;
        XAccessibleContext xAccessibleContext = xAccessible.getAccessibleContext();
        if (xAccessibleContext == null) return null;
        short s = xAccessibleContext.getAccessibleRole();
        XAccessibleStateSet xAccessibleStateSet = xAccessibleContext.getAccessibleStateSet();
        XAccessibleComponent xAccessibleComponent = (XAccessibleComponent)UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)xAccessibleContext);
        if (s == 12) {
            window = new Dialog((java.awt.Frame)new Application(), xAccessibleContext.getAccessibleName(), xAccessibleStateSet.contains((short)16), xAccessibleComponent);
        } else if (s == 1) {
            window = new Alert((java.awt.Frame)new Application(), xAccessibleContext.getAccessibleName(), xAccessibleStateSet.contains((short)16), xAccessibleComponent);
        } else if (s == 21) {
            window = new Frame(xAccessibleContext.getAccessibleName(), xAccessibleComponent);
        } else {
            if (s != 67) return null;
            java.awt.Window window2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            if (window2 == null) return null;
            window = new Window(window2, xAccessibleComponent);
        }
        AccessibleObjectFactory.populateContainer(window, xAccessibleContext, window);
        window.setFocusTraversalPolicy(focusTraversalPolicy);
        window.setVisible(true);
        Component component = ((NativeFrame)((Object)window)).getInitialComponent();
        if (component == null) return window;
        AccessibleObjectFactory.postWindowGainedFocus(window);
        return window;
    }
}

