/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.accessibility.misc;

import com.sun.star.bridge.XUnoUrlResolver;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintStream;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import org.openoffice.accessibility.misc.MessageArea;
import org.openoffice.accessibility.misc.SimpleOffice;

public class OfficeConnection
extends TimerTask {
    public static final long snDelay = 3000L;
    private static OfficeConnection saInstance = null;
    private static String ssDefaultPipeName = System.getenv("USER");
    private XMultiServiceFactory maServiceManager;
    String msPipeName = ssDefaultPipeName;
    private boolean mbInitialized = false;
    private PrintStream maOut;
    private Timer maTimer;
    private Vector maListeners;

    public static synchronized OfficeConnection Instance() {
        if (saInstance == null) {
            saInstance = new OfficeConnection();
        }
        return saInstance;
    }

    public static void SetPipeName(String string) {
        ssDefaultPipeName = string;
    }

    public void AddConnectionListener(ActionListener actionListener) {
        SimpleOffice simpleOffice = SimpleOffice.Instance();
        if (this.IsValid()) {
            actionListener.actionPerformed(new ActionEvent(simpleOffice, 0, "<connected>"));
        }
        this.maListeners.add(actionListener);
    }

    public XMultiServiceFactory GetServiceManager() {
        return this.maServiceManager;
    }

    public boolean IsValid() {
        return this.maServiceManager != null;
    }

    private boolean Connect() {
        block2: {
            this.mbInitialized = true;
            String string = "uno:pipe,name=" + this.msPipeName + ";urp;StarOffice.ServiceManager";
            try {
                XMultiServiceFactory xMultiServiceFactory = Bootstrap.createSimpleServiceManager();
                XUnoUrlResolver xUnoUrlResolver = (XUnoUrlResolver)UnoRuntime.queryInterface(XUnoUrlResolver.class, (Object)xMultiServiceFactory.createInstance("com.sun.star.bridge.UnoUrlResolver"));
                this.maServiceManager = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)xUnoUrlResolver.resolve(string));
            }
            catch (Exception exception) {
                if (this.maOut == null) break block2;
                this.maOut.println("Could not connect with " + string + " : " + exception);
                this.maOut.println("Please start OpenOffice/StarOffice with \"-accept=pipe,name=" + this.msPipeName + ";urp;\"");
            }
        }
        return this.maServiceManager != null;
    }

    public void run() {
        if (!this.IsValid()) {
            MessageArea.println("trying to connect");
            if (this.Connect()) {
                this.cancel();
                ActionEvent actionEvent = new ActionEvent(this, 0, "<connected>");
                for (int i = 0; i < this.maListeners.size(); ++i) {
                    ((ActionListener)this.maListeners.elementAt(i)).actionPerformed(actionEvent);
                }
            }
        }
    }

    private OfficeConnection() {
        this(null);
    }

    private OfficeConnection(PrintStream printStream) {
        this.maOut = printStream;
        this.maListeners = new Vector();
        this.maServiceManager = null;
        this.maTimer = new Timer(true);
        this.maTimer.schedule((TimerTask)this, 0L, 3000L);
    }
}

